@extends('installer.layout')

@section('title', 'Install')
@section('subtitle', 'Ready to install your application')

@section('content')
    <h2 style="margin-bottom: var(--spacing-lg); color: var(--white);">Ready to Install</h2>
    
    <p style="margin-bottom: var(--spacing-lg);">
        The installer has collected all the necessary information. Please review the details below before proceeding with the installation.
    </p>
    
    <div class="info-card">
        <h3><i class="fas fa-clipboard-list"></i> Installation Summary</h3>
        
        <div class="info-item">
            <div class="info-label">Application Name</div>
            <div class="info-value">{{ session('app_name') }}</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Application URL</div>
            <div class="info-value">{{ session('app_url') }}</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Database Host</div>
            <div class="info-value">{{ session('db_host') }}:{{ session('db_port') }}</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Database Name</div>
            <div class="info-value">{{ session('db_database') }}</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">Database User</div>
            <div class="info-value">{{ session('db_username') }}</div>
        </div>
        
        <div class="info-item">
            <div class="info-label">License Key</div>
            <div class="info-value">{{ substr(session('license_key'), 0, 8) }}••••••••</div>
        </div>
    </div>
    
    <p style="margin-bottom: var(--spacing-lg);">
        Click "Install Now" to finalize the installation. This process will:
    </p>
    
    <ul style="margin-bottom: var(--spacing-xl); padding-left: var(--spacing-xl);">
        <li style="margin-bottom: var(--spacing-xs);">Configure your .env file with the settings above</li>
        <li style="margin-bottom: var(--spacing-xs);">Generate a secure application key</li>
        <li style="margin-bottom: var(--spacing-xs);">Run database migrations and seeders</li>
        <li style="margin-bottom: var(--spacing-xs);">Finalize the installation</li>
    </ul>
    
    <div style="background-color: rgba(255, 193, 7, 0.1); border-radius: var(--border-radius-md); padding: var(--spacing-md); margin-bottom: var(--spacing-lg); border: 1px solid rgba(255, 193, 7, 0.2);">
        <div style="display: flex; align-items: flex-start;">
            <i class="fas fa-exclamation-triangle" style="color: var(--warning); margin-right: var(--spacing-sm); margin-top: 3px;"></i>
            <p style="font-size: 0.9rem; margin: 0;">
                <strong>Warning:</strong> This process may take several minutes to complete. Please do not close this window or refresh the page during the installation.
            </p>
        </div>
    </div>
    
    <form action="{{ route('installer.do_install') }}" method="POST" id="installForm">
        @csrf
        <div id="installProgress" style="display: none; margin-top: var(--spacing-xl); margin-bottom: var(--spacing-lg);">
            <div style="text-align: center; margin-bottom: var(--spacing-lg);">
                <div class="loader"></div>
                <h3 style="margin-top: var(--spacing-md); color: var(--white);">Installing...</h3>
                <p id="progressText" style="margin-top: var(--spacing-sm); color: var(--light-gray);">Preparing installation process...</p>
            </div>
            
            <div style="background-color: var(--dark-gray); border-radius: var(--border-radius-md); overflow: hidden; height: 12px;">
                <div id="progressBar" style="width: 0%; height: 100%; background-color: var(--primary-color); transition: width 0.5s ease;"></div>
            </div>
        </div>
    @endsection

    @section('footer')
        <a href="{{ route('installer.app') }}" class="btn">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary" id="installButton">
            <i class="fas fa-cog"></i> Install Now
        </button>
    </form>
@endsection

@section('scripts')
<script>
    document.getElementById('installForm').addEventListener('submit', function() {
        document.getElementById('installProgress').style.display = 'block';
        document.getElementById('installButton').disabled = true;
        document.getElementById('installButton').innerHTML = '<i class="fas fa-spin fa-spinner"></i> Installing...';
        
        const progressText = document.getElementById('progressText');
        const progressBar = document.getElementById('progressBar');
        
        // Progressive bar update
        setTimeout(() => {
            progressBar.style.width = '10%';
            progressText.innerText = 'Creating environment file...';
        }, 500);
        
        setTimeout(() => {
            progressBar.style.width = '30%';
            progressText.innerText = 'Generating application key...';
        }, 2000);
        
        setTimeout(() => {
            progressBar.style.width = '50%';
            progressText.innerText = 'Setting up database...';
        }, 4000);
        
        setTimeout(() => {
            progressBar.style.width = '70%';
            progressText.innerText = 'Running migrations...';
        }, 6000);
        
        setTimeout(() => {
            progressBar.style.width = '85%';
            progressText.innerText = 'Seeding database...';
        }, 8000);
        
        setTimeout(() => {
            progressBar.style.width = '95%';
            progressText.innerText = 'Finalizing installation...';
        }, 10000);
    });
</script>
@endsection